<?php

if (!defined('ABSPATH')) {
    exit;
}

final class GP_Utils
{
    /**
     * URL normalize for comparing allowed domains.
     * Keeps scheme + host + port + path (WordPress subdir) and ensures trailing slash.
     */
    public static function normalize_url_for_compare(string $url): string
    {
        $url = trim($url);
        if ($url === '') {
            return '';
        }

        $url = str_replace('\\', '/', $url);

        $parts = wp_parse_url($url);
        if (!is_array($parts) || empty($parts['host'])) {
            return trailingslashit($url);
        }

        $scheme = !empty($parts['scheme']) ? strtolower((string) $parts['scheme']) : 'http';
        $host   = strtolower((string) $parts['host']);
        $port   = isset($parts['port']) ? ':' . (int) $parts['port'] : '';
        $path   = isset($parts['path']) ? (string) $parts['path'] : '/';

        $path = '/' . ltrim($path, '/');
        $path = trailingslashit($path);

        return $scheme . '://' . $host . $port . $path;
    }

    public static function normalize_version(string $v): string
    {
        $v = trim($v);
        if ($v === '') {
            return '';
        }

        if ($v[0] === 'v' || $v[0] === 'V') {
            $v = substr($v, 1);
        }

        $parts = preg_split('/\s+/', $v);
        $v = is_array($parts) && isset($parts[0]) ? (string) $parts[0] : $v;

        return trim($v);
    }

    public static function is_update_available(string $installed_ver, string $remote_latest): bool
    {
        $iv = self::normalize_version($installed_ver);
        $rv = self::normalize_version($remote_latest);

        if ($iv === '' || $rv === '') {
            return false;
        }

        return version_compare($iv, $rv, '<');
    }
}
