<?php
if (!defined('ABSPATH')) { exit; }

final class GP_I18n
{
    // auto | en | fa
    public const OPTION_KEY = 'gp_plugin_lang';

    public static function get_setting(): string
    {
        $v = get_option(self::OPTION_KEY, 'auto');
        $v = is_string($v) ? trim($v) : 'auto';
        return in_array($v, ['auto', 'en', 'fa'], true) ? $v : 'auto';
    }

    public static function set_setting(string $mode): void
    {
        $mode = trim($mode);
        $mode = in_array($mode, ['auto', 'en', 'fa'], true) ? $mode : 'auto';

        // add if missing (autoload false)، otherwise update
        if (get_option(self::OPTION_KEY, null) === null) {
            add_option(self::OPTION_KEY, $mode, '', false);
        } else {
            update_option(self::OPTION_KEY, $mode, false);
        }
    }

    public static function current_lang(): string
    {
        $mode = self::get_setting();

        if ($mode === 'fa') return 'fa';
        if ($mode === 'en') return 'en';

        // auto: detect from current WP locale
        $locale = function_exists('determine_locale') ? (string) determine_locale() : (string) get_locale();
        return self::is_persian_locale($locale) ? 'fa' : 'en';
    }

    public static function is_persian_locale(string $locale): bool
    {
        $locale = strtolower(str_replace('-', '_', trim($locale)));
        return (strpos($locale, 'fa') === 0); // fa, fa_IR, fa_AF, ...
    }

    public static function text(string $en, string $fa): string
    {
        return (self::current_lang() === 'fa') ? $fa : $en;
    }
}

// helper for easy usage in templates
if (!function_exists('gp_text')) {
    function gp_text(string $en, string $fa = ''): string {
        return GP_I18n::text($en, $fa !== '' ? $fa : $en);
    }
}
